/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.sell.BidRequest;
import com.google.common.collect.Maps;
import java.util.Map;

public class ExchangeContext {
    private static final ThreadLocal<ExchangeContext> THREAD_LOCAL = new ThreadLocal<ExchangeContext>(){

        @Override
        protected ExchangeContext initialValue() {
            return new ExchangeContext();
        }
    };
    private static final String KEY_BIDREQUEST = "$$BID_REQUEST$$";
    private static final String KEY_BUYER = "$$BUYER$$";
    private static final String KEY_DISPATCH_CONFIG = "$$DISPATCH_CONFIG$$";
    private final Map<Object, Object> attachment = Maps.newHashMap();

    private static ExchangeContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    static void putBidRequest(BidRequest bidRequest) {
        ExchangeContext.get().attachment.put(KEY_BIDREQUEST, bidRequest);
    }

    static void putBuyer(Buyer buyer) {
        ExchangeContext.get().attachment.put(KEY_BUYER, buyer);
    }

    static void putDispatchConfig(Long configId) {
        ExchangeContext.get().attachment.put(KEY_DISPATCH_CONFIG, configId);
    }

    public static void put(Object key, Object value) {
        ExchangeContext context = ExchangeContext.get();
        context.attachment.put(key, value);
    }

    public static Object get(Object key) {
        ExchangeContext context = ExchangeContext.get();
        return context.attachment.get(key);
    }

    public static BidRequest getBidRequest() {
        Object o = ExchangeContext.get().attachment.get(KEY_BIDREQUEST);
        if (o instanceof BidRequest) {
            return (BidRequest)o;
        }
        return null;
    }

    public static Buyer getBuyer() {
        Object o = ExchangeContext.get().attachment.get(KEY_BUYER);
        if (o instanceof Buyer) {
            return (Buyer)o;
        }
        return null;
    }

    public static Long getDispatcherConfigId() {
        Object o = ExchangeContext.get().attachment.get(KEY_DISPATCH_CONFIG);
        if (o instanceof Long) {
            return (Long)o;
        }
        return null;
    }
}

