package com.bxm.adx.common.buy.buyers;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.plugin.PluginHolder;

import java.util.Map;

/**
 * 抽象的，从插件容器中获取卖家实现。
 *
 * @author allen
 * @since 2019-12-16
 */
public abstract class AbstractPluginBuyersImpl implements PriorityBuyers {

    private final PluginHolder pluginHolder;

    protected AbstractPluginBuyersImpl(PluginHolder pluginHolder) {
        this.pluginHolder = pluginHolder;
    }

    @Override
    public Map<String, Buyer> getAllBuyers() {
        return pluginHolder.getBuyers();
    }
}
