package com.bxm.adx.common.buy.dsp;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * DSP
 * @author allen
 * @since 2019-12-16
 */
@Data
public class Dsp {

    private Long id;
    private String dspCode;
    private String dspName;
    private String apiUrl;
    private String apiKey;
    private String ext;

    /**
     * 连接超时设置
     */
    private Integer connectTimeOut;
    /**
     * 读取结果超时设置
     */
    private Integer socketTimeOut;
    /**
     * QPS限制
     */
    private Integer qps;
    /**
     * 广告主
     */
    private Long advertiser;
    /**
     * 是否禁用
     */
    private Integer deleted;

    /**
     * 结算方式
     * @see com.bxm.mccms.facade.enums.DspEnum.SettleType
     */
    private Integer settleType;

    /**
     * 结算配置:结算方式为分成时为0-100分成比例，结算方式为固价时为0-200固价CPM
     */
    private BigDecimal settleConfig;

    public boolean isForbidden() {
        if (Objects.nonNull(deleted)) {
            if (deleted == 1) {
                return true;
            }
        }
        return false;
    }
}
