package com.bxm.adx.common.buy.optimization;

import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2022/4/1
 **/
@CachePush("POSITION_DSP_OPTIMIZATION")
@Component
@Slf4j
public class OptimizationDaoImpl implements OptimizationDao, Pushable {

    private final Updater updater;
    private final Fetcher fetcher;

    public OptimizationDaoImpl(Updater updater, Fetcher fetcher) {
        this.updater = updater;
        this.fetcher = fetcher;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (null == data) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("optimization push data = {}", new String(data));
        }
        Optimization optimization = JsonHelper.convert(data, Optimization.class);
        if (Objects.isNull(optimization)) {
            return;
        }
        String positionId = optimization.getPositionId();
        if (StringUtils.isEmpty(optimization.getPositionId())) {
            return;
        }
        updater.hremove(getKeyGenerator(optimization.getPositionId()), optimization.getId().toString());
        if (optimization.isOpened()) {
            updater.hupdate(getKeyGenerator(positionId), optimization.getId().toString(), optimization);
        }
    }

    private KeyGenerator getKeyGenerator(String positionId) {
        return () -> KeyBuilder.build("ADX", "OPTIMIZATION", "PID", positionId);
    }

    @Override
    public Optimization getOptimizationByPositionId(String posId) {
        Map<String, Optimization> map = fetcher.hfetchall(getKeyGenerator(posId), Optimization.class);
        if (CollectionUtils.isEmpty(map)) {
            return null;
        } else {
            return map.entrySet().iterator().next().getValue();
        }
    }
}
