package com.bxm.adx.common.filter;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.ip.IpService;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.ip.IP;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * <h3>广告位地域限制</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/23 10:46
 */
@Slf4j
@Component
public class PositionRegionLimiterFilter extends AbstractPositionFilter {

    private final IpService ipService;

    public PositionRegionLimiterFilter(IpService ipService) {
        this.ipService = ipService;
    }

    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {
        final List<Position> positions = marketOrders.getPositions();
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }

        List<String> list = Lists.newArrayList();

        IP ipp = getIp(marketOrders.getBidRequest());

        positions.forEach(position -> {
            String regionCodes = position.getRegion();
            if (StringUtils.isEmpty(regionCodes)) {
                return;
            }

            Set<String> set = Sets.newHashSet();
            set.addAll(Arrays.asList(regionCodes.split(",")));

            if (Objects.nonNull(ipp) && ipp.in(set)) {
                return;
            }

            list.add(position.getPositionId());
        });
        return list;
    }

    private IP getIp(BidRequest bidRequest) {
        IP ipp = null;
        if (bidRequest != null) {
            Device device = bidRequest.getDevice();
            if (device != null) {
                String ip = device.getIp();
                if (!StringUtils.isEmpty(ip)) {
                    ipp = ipService.analyze(ip);
                    AdxContextFactory.get().setIp(ipp);
                }
            }
        }
        return ipp;
    }

    @Override
    public int order() {
        return 3;
    }
}
