package com.bxm.adx.common.market;

import java.util.List;

import com.bxm.warcar.cache.Counter;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import com.bxm.adx.common.market.exchange.PriorityExchanger;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.revealbottom.RevealBottom;
import com.bxm.adx.common.sell.BidResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * RTB 竞价市场，支持优先级批次竞价。
 *
 * @author allen
 * @since 2019-12-16
 */
@Slf4j
@Primary
@Configuration
public class DefaultMarketImpl implements Market {

    private final PriorityExchanger priorityExchanger;
    private final Filter filter;
    private final RevealBottom revealBottom;
    private final Counter counter;
    private final MonitorWrapper monitorWrapper;
    public DefaultMarketImpl(PriorityExchanger priorityExchanger, Filter filter, RevealBottom revealBottom,
                             Counter counter, MonitorWrapper monitorWrapper) {
        this.priorityExchanger = priorityExchanger;
        this.filter = filter;
        this.revealBottom = revealBottom;
        this.counter = counter;
        this.monitorWrapper = monitorWrapper;
    }

    @Override
    public BidResponse exchange(MarketOrders orders) {

        if (CollectionUtils.isEmpty(orders.getPositions())) {

            if (log.isDebugEnabled()) {
                log.debug("positions is null {} ", orders.getBidRequest().getImps());
            }
            return null;
        }

        List<Deal> deals = priorityExchanger.exchange(orders);
        if (CollectionUtils.isNotEmpty(deals)) {
            filter.filter(deals);
        } else {
            //兜底
            deals = revealBottom.exchange(orders);
            if (CollectionUtils.isEmpty(deals)) {
                return null;
            }
        }

        BidResponse bidResponse = DealWrapper.merge(deals);
        monitorWrapper.monitorWrapper(bidResponse);
        return bidResponse;
    }
}
