package com.bxm.adx.common.openlog.event.internal;

import java.util.EventObject;

import com.bxm.adx.common.sell.BidRequest;

/**
 * adx向dsp发起请求事件
 * @author fgf
 * @date 2022/6/1
 **/
public class AdxRequestEvent extends EventObject {
    private final BidRequest sspRequest;
    private final BidRequest adxRequest;
    private final String dspId;
    private final String configId;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @param sspRequest
     * @param adxRequest
     * @param dspId
     * @param configId
     * @throws IllegalArgumentException if source is null.
     */
    public AdxRequestEvent(Object source, BidRequest sspRequest, BidRequest adxRequest, String dspId, String configId) {
        super(source);
        this.sspRequest = sspRequest;
        this.adxRequest = adxRequest;
        this.dspId = dspId;
        this.configId = configId;
    }

    public String getDspId() {
        return dspId;
    }

    public String getConfigId() {
        return configId;
    }

    public BidRequest getSspRequest() {
        return sspRequest;
    }

    public BidRequest getAdxRequest() {
        return adxRequest;
    }
}
