package com.bxm.adx.common.openlog.listener.external;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

import org.springframework.context.annotation.Configuration;

import com.bxm.adx.common.openlog.event.external.AdShowEvent;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Adx;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import lombok.extern.slf4j.Slf4j;

/**
 * @author allen
 * @date 2022-04-25
 * @since 1.0
 */
@Slf4j
@Configuration
public class AdShowForDspMaxExposureLimiterEventListener implements EventListener<AdShowEvent> {

    private final Counter counter;

    public AdShowForDspMaxExposureLimiterEventListener(Counter counter) {
        this.counter = counter;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdShowEvent event) {
        handleDspExposureWithConfigId(event);
    }

    private void handleDspExposureWithConfigId(AdShowEvent event) {
        KeyValueMap map = event.getLog();
        String dspId = map.getFirst(Adx.Param.DSPID);
        String configId = map.getFirst(Adx.Param.CONFIGID);

        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getPositionDspExposure(configId, dspId);
        LocalDateTime midnight = LocalDateTime.now().plusDays(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(),midnight);
        counter.incrementAndGet(keyGenerator, (int)seconds);
    }
}
