package com.bxm.adx.common.openlog.listener.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.DspBidEvent;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

/**
 * @author fgf
 * @date 2022/6/1
 **/
@Configuration
public class DoDspBidEventListener implements EventListener<DspBidEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DoDspBidEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(DspBidEvent event) {
        String url = properties.getOpenLog().create(OpenlogConstants.Mt.DSP_RESPONSE_MT, "chgtypm", "chgtypd");
        BuildAttribute attribute = new BuildAttribute(OpenlogConstants.Mt.DSP_RESPONSE_MT)
                .setDspId(event.getDspId())
                .setSspRequest(event.getSspRequest())
                .setAdxRequest(event.getAdxRequest())
                .setDspResponse(event.getDspResponse());
        url = macrosHandler.replaceAll(url, attribute);
        openLogClient.asyncRequest(url);
    }
}
