package com.bxm.adx.common.sell.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adx.common.PositionSceneTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Impression implements Serializable {
    private String id;
    private String tag_id;
    @JSONField(name = "native")
    private Native a_native;
    private Integer instl;
    /**
     * 底价/分
     */
    private BigDecimal bid_floor;
    /**
     * 最高价/分
     */
    private BigDecimal bid_top;
    private Integer secure;
    private Integer download;
    private Integer support_deep_link;
    private Integer num;
    private Integer w;
    private Integer h;
    private String ext;
    private Integer type;
    /**
     * 广告位类型（场景）
     * @see com.bxm.adx.common.PositionSceneTypeEnum
     */
    private Integer imp_type;
    /**
     * 计费模式
     */
    private Integer bid_model;
}
