package com.bxm.adx.common.sell.ssp.resp;

import com.bxm.mcssp.common.entity.PositionJsonConfig;
import lombok.*;

import java.io.Serializable;

/**
 * Created by Arei on 2020/11/4.
 */
@lombok.Data
public class Config implements Serializable{

    /**
     * 开屏时间，单位为秒
     */
    private Integer boot_time;

    /**
     * 显示结束页：0不显示，1显示
     */
    private Integer show_endpage;

    /**
     * 点击视频的行为：1视频暂停播放,2触发广告点击
     */
    private Integer click_video_action;

    /**
     * 显示广告角标：0不显示，1显示
     */
    private Integer show_ad_logo;

    /**
     * 刷新间隔时间，单位为秒
     */
    private Integer refreshInterval_time;

    /**
     * 刷新模式 1定时2点击
     */
    private String refresh_model;
    /**
     * 展示标题栏:0不显示，1显示
     */
    private Integer show_title_bar;

    /**
     * 开启预加载：0关闭，1开启
     */
    private Integer open_preloading;

    /**
     * 是否优先使用AE按钮 0否1是
     */
    private Integer boot_ae_btn;

    /**
     * 是否开启全屏点击 0否1是
     */
    private Integer boot_full_screen_click;

    /**
     * 曝光n秒后可关闭
     */
//    private Integer screen_show_close;

    /**
     * 加载最大时长 单位秒
     */
    private Integer screen_load_duration;

    /**
     * 广告标识：0-无/1-有，默认为无
     */
    private Integer ad_logo;

    /**
     * 显示活动关闭按钮：0不显示，1显示
     */
    private Integer isShowActivityCloseButton;

    /**
     * 显示跳过按钮时间，单位为秒，为空则不显示
     */
    private Integer showSkipButton;

    /**
     * 下载弹窗开关0关/1开
     */
    private Integer downloadPopSwitch;

    /**
     * 下载通知栏样式
     * 0.下载在进行中和完成后都显示
     * 1.下载在进行中显示
     * 2.下载在完成后显示
     */
    private Integer downloadBarStyle;

    /**
     * 外部对接api渠道时，有一些渠道要求移除广告请求头x-requested-with 里携带的包名，避免其渠道上游发现其api投放在未合作的媒体上；
     *
     * 0关闭
     * 1开启（即x-requested-with里带上包名）
     */
    private Integer httpHeaderSwitch;
}
