/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.buyers;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.buyers.AbstractPluginBuyersImpl;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.plugin.PluginHolder;
import com.bxm.adx.common.sell.position.Position;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Primary
@Configuration
public class DispatcherPluginBuyersImpl
extends AbstractPluginBuyersImpl {
    private DispatcherService dispatcherService;
    private final AdxProperties properties;
    private final DspService dspService;

    protected DispatcherPluginBuyersImpl(PluginHolder pluginHolder, AdxProperties properties, DspService dspService) {
        super(pluginHolder);
        this.properties = properties;
        this.dspService = dspService;
    }

    @Override
    public List<List<BuyerWrapper>> findAsPriority(Position position, BigDecimal minPrice, BigDecimal maxPrice) {
        Integer maxPriority;
        Set<Integer> keys;
        if (Objects.nonNull(minPrice) && Objects.nonNull(maxPrice) && maxPrice.compareTo(BigDecimal.ZERO) > 0) {
            AdxContextFactory.get().setSDKConcurrentModel(true);
        } else {
            AdxContextFactory.get().setSDKConcurrentModel(false);
        }
        String positionId = position.getPositionId();
        Map<Integer, Collection<Dispatcher>> dsps = this.dispatcherService.getPriority(positionId, minPrice, maxPrice);
        Integer initSize = this.properties.getMaxCapacityOfBuyers();
        if (!MapUtils.isEmpty(dsps) && !CollectionUtils.isEmpty(keys = dsps.keySet()) && (maxPriority = (Integer)keys.stream().max(Integer::compareTo).get()) != null && maxPriority.compareTo(initSize) == 1) {
            initSize = maxPriority;
        }
        List<List<BuyerWrapper>> list = this.emptyListWithCapacity(initSize);
        Map<String, Buyer> buyers = this.getAllBuyers();
        for (Map.Entry<Integer, Collection<Dispatcher>> entry : dsps.entrySet()) {
            ArrayList buyerList;
            Integer n = entry.getKey();
            Collection<Dispatcher> value = entry.getValue();
            int index = n - 1;
            List<Object> list2 = CollectionUtils.isEmpty(list) ? null : (buyerList = list.size() > index ? list.get(index) : null);
            if (null == buyerList) {
                buyerList = Lists.newArrayList();
                list.add(index, buyerList);
            }
            for (Dispatcher dispatcher : value) {
                String dspCode;
                Buyer buyer;
                Long dspId = dispatcher.getDspId();
                Dsp dsp = this.dspService.get(dspId);
                if (null == dsp || null == (buyer = buyers.get(dspCode = dsp.getDspCode()))) continue;
                buyerList.add(new BuyerWrapper(buyer, dispatcher));
            }
        }
        list.removeIf(List::isEmpty);
        if (AdxContextFactory.get().isSDKConcurrentModel()) {
            ArrayList<BuyerWrapper> buyerWrapperList = new ArrayList<BuyerWrapper>();
            for (List<BuyerWrapper> list3 : list) {
                if (!CollectionUtils.isNotEmpty(list3)) continue;
                buyerWrapperList.addAll(list3);
            }
            ArrayList<List<BuyerWrapper>> arrayList = new ArrayList<List<BuyerWrapper>>();
            arrayList.add(buyerWrapperList);
            return arrayList;
        }
        return list;
    }

    private List<List<BuyerWrapper>> emptyListWithCapacity(int size) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            list.add(Lists.newArrayList());
        }
        return list;
    }

    @Autowired
    public void setDispatcherService(DispatcherService dispatcherService) {
        this.dispatcherService = dispatcherService;
    }
}

