/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.optimization;

import com.bxm.adx.common.buy.optimization.Optimization;
import com.bxm.adx.common.buy.optimization.OptimizationDao;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@CachePush(value="POSITION_DSP_OPTIMIZATION")
@Component
public class OptimizationDaoImpl
implements OptimizationDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(OptimizationDaoImpl.class);
    private final Updater updater;
    private final Fetcher fetcher;

    public OptimizationDaoImpl(Updater updater, Fetcher fetcher) {
        this.updater = updater;
        this.fetcher = fetcher;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        Optimization optimization;
        if (null == data) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("optimization push data = {}", (Object)new String(data));
        }
        if (Objects.isNull(optimization = (Optimization)JsonHelper.convert((byte[])data, Optimization.class))) {
            return;
        }
        String positionId = optimization.getPositionId();
        if (StringUtils.isEmpty((CharSequence)optimization.getPositionId())) {
            return;
        }
        this.updater.hremove(this.getKeyGenerator(optimization.getPositionId()), new String[]{optimization.getId().toString()});
        if (optimization.isOpened()) {
            this.updater.hupdate(this.getKeyGenerator(positionId), optimization.getId().toString(), (Object)optimization);
        }
    }

    private KeyGenerator getKeyGenerator(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "OPTIMIZATION", "PID", positionId});
    }

    @Override
    public Optimization getOptimizationByPositionId(String posId) {
        Map map = this.fetcher.hfetchall(this.getKeyGenerator(posId), Optimization.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            return null;
        }
        return (Optimization)map.entrySet().iterator().next().getValue();
    }
}

