/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.common.market.exchange.Exchanger;
import com.bxm.adx.common.market.exchange.PriorityExchanger;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DefaultPriorityExchanger
implements PriorityExchanger {
    private static final Logger log = LoggerFactory.getLogger(DefaultPriorityExchanger.class);
    private final AdxProperties properties;
    private final Exchanger exchanger;

    public DefaultPriorityExchanger(AdxProperties properties, Exchanger exchanger) {
        this.properties = properties;
        this.exchanger = exchanger;
    }

    @Override
    public List<Deal> exchange(MarketOrders orders) {
        BidRequest request = orders.getBidRequest();
        List<MarketRequest> requestList = orders.getRequests();
        if (CollectionUtils.isEmpty(requestList)) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        ArrayList failResult = Lists.newArrayList();
        for (MarketRequest marketRequest : requestList) {
            Set<BuyerWrapper> buyers = marketRequest.getBuyers();
            Set<Position> positions = marketRequest.getPositions();
            HashSet positionIds = Sets.newHashSet();
            for (Position position : positions) {
                positionIds.add(position.getPositionId());
                positionIds.add(position.getAppPositionId());
            }
            ArrayList imps = Lists.newArrayList(request.getImps());
            imps.removeIf(impression -> !positionIds.contains(impression.getTag_id()));
            BidRequest e = new BidRequest();
            BeanUtils.copyProperties((Object)request, (Object)e);
            e.setImps(imps);
            List<Deal> deals = this.exchanger.bidding(e, buyers);
            if (CollectionUtils.isNotEmpty(deals)) {
                for (Deal deal : deals) {
                    if (deal.isBidSuccess()) {
                        result.add(deal);
                        continue;
                    }
                    failResult.add(deal);
                }
            }
            if (AdxContextFactory.get().isOptimization() || !CollectionUtils.isNotEmpty((Collection)result)) continue;
            return result;
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            return result;
        }
        if (failResult.size() == 1) {
            throw new AdxException(((Deal)failResult.iterator().next()).getAdxErrEnum());
        }
        throw new AdxException(AdxErrEnum.DSP_EMPTY_RESPONSE);
    }
}

