package com.bxm.adx.common.autoconfigure;

import java.net.URLEncoder;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.cipher.PriceCipher;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacros;

import lombok.extern.slf4j.Slf4j;

/**
 * @author allen
 * @date 2021-06-17
 * @since 1.0
 */
@Configuration
@Slf4j
public class BuildAttributeMacrosAutoConfiguration {
    private final AdxProperties adxProperties;

    public BuildAttributeMacrosAutoConfiguration(AdxProperties adxProperties) {
        this.adxProperties = adxProperties;
    }


    @Bean
    public BuildAttributeStringMacros spm() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.SPM;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getSspRequest().getId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros ver() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.VER;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return "";
            }
        };
    }


    @Bean
    public BuildAttributeStringMacros bidid() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.BIDID;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getSspRequest().getId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros tagId() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.TAGID;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getTagId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros dTagId() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.DTAGID;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getdTagId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros timestamp() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.TIMESTAMP;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return String.valueOf(System.currentTimeMillis());
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros dAppId() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.DAPPID;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getdAppId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros appId() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.APPID;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getAppId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros price() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.PRICE;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getPrice();
            }

            @Override
            public String getIfBlankValue() {
                return OpenlogConstants.Macros.PRICE;
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros configId() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.CONFIGID;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getConfigId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros dspId() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.DSPID;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getDspId();
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros dspPrice() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.DPRICE;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                String dspPrice = Objects.nonNull(attribute.getDspResponsePrice()) ? attribute.getDspResponsePrice().toString() : null;
                if (StringUtils.isNotEmpty(dspPrice)) {
                    try {
                        dspPrice = PriceCipher.encryptWin(dspPrice, adxProperties.getCipherProperties().getDspPriceKey());
                        dspPrice = URLEncoder.encode(dspPrice, "UTF-8");
                    } catch (Exception e) {
                        log.error("cipher err", e);
                    }
                }
                return dspPrice;
            }

            @Override
            public String getIfBlankValue() {
                return "";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros mediaId() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.MEDIA_ID;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return attribute.getMediaId();
            }

            @Override
            public String getIfBlankValue() {
                return "";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros chgtypm() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.CHARGE_TYPE_MEDIA;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return AdxConstants.BidModel.CPM + "";
            }
        };
    }

    @Bean
    public BuildAttributeStringMacros chgtypd() {
        return new BuildAttributeStringMacros() {
            @Override
            public String getMacroString() {
                return OpenlogConstants.Macros.CHARGE_TYPE_DSP;
            }

            @Override
            public String apply(BuildAttribute attribute) {
                return AdxConstants.BidModel.CPM + "";
            }
        };
    }

}
