package com.bxm.adx.common.buy.dsp;

import lombok.Data;

import java.util.Objects;

/**
 * DSP
 * @author allen
 * @since 2019-12-16
 */
@Data
public class Dsp {

    private Long id;
    private String dspCode;
    private String dspName;
    private String apiUrl;
    private String apiKey;
    private String ext;

    /**
     * 连接超时设置
     */
    private Integer connectTimeOut;
    /**
     * 读取结果超时设置
     */
    private Integer socketTimeOut;
    /**
     * QPS限制
     */
    private Integer qps;
    /**
     * 广告主
     */
    private Long advertiser;
    /**
     * 是否禁用
     */
    private Integer deleted;

    public boolean isForbidden() {
        if (Objects.nonNull(deleted)) {
            if (deleted == 1) {
                return true;
            }
        }
        return false;
    }
}
