package com.bxm.adx.common.sell;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.request.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * @author allen
 * @since 2019-12-12
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BidRequest {

    private String id;
    @Deprecated
    private Integer adx_type;
    private List<Impression> imps;
    @Deprecated
    private Integer c_type;
    private App app;
    private Device device;
    private User user;
    private Geo geo;
    private Set<String> cur;
    @Deprecated
    private Integer bid_type;
    private Integer at;
    @Deprecated
    private List<String> deal_ids;
    @Deprecated
    private Integer bill_type;
    private Integer test;
    private Integer t_max;
    @Deprecated
    private List<String> b_cat;
    @Deprecated
    private List<String> b_seat;
    @Deprecated
    private List<String> w_seat;
    @Deprecated
    private List<String> b_adv;
    @Deprecated
    private List<String> b_app;
    private String ext;
    private Integer ad_type;
    private String entrance_name;
    //@JSONField(serialize = false)
    private String sdk_ver;

    /**
     * 客户端请求接口时所使用的服务名（域名）
     */
    private String serverName;
    /**
     * 请求方式：1-SDK定时请求 2-app主动请求
     */
    private Integer request_model;
    /**
     * 合作类型： 1 分成，2 竞价，3 包段，4 UV
     */
    private Integer cooperationType;
    /**
     * 对接类型：1 API，2 SDK
     */
    private Integer dockingMethodType;
    /**
     * bxm广告位id
     */
    private String bxmTagId;

    /**
     * 媒体方ID
     * @see AdxConstants.Media
     */
    private String mediaId;
    /**
     * 判断是否时app主动请求推送广告
     * @return
     */
    public boolean isAppDrivingRequest() {
        return Objects.isNull(request_model) ? false : request_model == AdxConstants.RequestModel.DRIVING;
    }
}
