/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class OpenLogProperties {
    private String scheme = "https";
    private String host = "openlog.bianxianmao.com";
    private int port = -1;
    private String reqDomain;
    private String consumerGroupForEventBus = "ADX";
    private String query = "/adx/s.gif?mt=__MT__&ver=__VER__&bxmid=__BXMID__&time=__TIMESTAMP__&bidid=__BID_COMMON_REQUEST_ID__&tagid=__TAGID__&price=__PRICE__&configid=__CONFIGID__&dspid=__DSPID__&appid=__APPID__&dappid=__DAPPID__&dtagid=__DTAGID__&dpr=__DSP_PRICE__&medid=__MEDIA_ID__&chgtypm=__CHARGE_TYPE_MEDIA__&chgtypd=__CHARGE_TYPE_DSP__&device=__DEVICE__";

    public String getReqDomain() {
        if (StringUtils.isBlank((String)this.reqDomain)) {
            this.reqDomain = UriComponentsBuilder.newInstance().scheme(this.getScheme()).host(this.getHost()).port(this.getPort()).build().toString();
        }
        return this.reqDomain;
    }

    public String create(int mt) {
        String queryString = this.query.replaceAll("__MT__", Objects.toString(mt));
        return UriComponentsBuilder.fromUriString((String)queryString).scheme(this.getScheme()).host(this.getHost()).port(this.getPort()).build().toString();
    }

    public String create(int mt, String ... removeParams) {
        return this.create(mt, (MultiValueMap<String, String>)null, removeParams);
    }

    public String create(int mt, MultiValueMap<String, String> customizeParams, String ... removeParams) {
        String url = this.create(mt);
        if (MapUtils.isEmpty(customizeParams) && ArrayUtils.isEmpty((Object[])removeParams)) {
            return url;
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url);
        UriComponents uriComponents = builder.build();
        MultiValueMap params = uriComponents.getQueryParams();
        LinkedMultiValueMap clone = new LinkedMultiValueMap((Map)params);
        if (Objects.nonNull(customizeParams)) {
            clone.addAll(customizeParams);
        }
        for (String exclude : removeParams) {
            clone.remove((Object)exclude);
        }
        builder.replaceQueryParams((MultiValueMap)clone);
        return builder.build().toString();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getConsumerGroupForEventBus() {
        return this.consumerGroupForEventBus;
    }

    public String getQuery() {
        return this.query;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setReqDomain(String reqDomain) {
        this.reqDomain = reqDomain;
    }

    public void setConsumerGroupForEventBus(String consumerGroupForEventBus) {
        this.consumerGroupForEventBus = consumerGroupForEventBus;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenLogProperties)) {
            return false;
        }
        OpenLogProperties other = (OpenLogProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$reqDomain = this.getReqDomain();
        String other$reqDomain = other.getReqDomain();
        if (this$reqDomain == null ? other$reqDomain != null : !this$reqDomain.equals(other$reqDomain)) {
            return false;
        }
        String this$consumerGroupForEventBus = this.getConsumerGroupForEventBus();
        String other$consumerGroupForEventBus = other.getConsumerGroupForEventBus();
        if (this$consumerGroupForEventBus == null ? other$consumerGroupForEventBus != null : !this$consumerGroupForEventBus.equals(other$consumerGroupForEventBus)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenLogProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $reqDomain = this.getReqDomain();
        result = result * 59 + ($reqDomain == null ? 43 : $reqDomain.hashCode());
        String $consumerGroupForEventBus = this.getConsumerGroupForEventBus();
        result = result * 59 + ($consumerGroupForEventBus == null ? 43 : $consumerGroupForEventBus.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    public String toString() {
        return "OpenLogProperties(scheme=" + this.getScheme() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", reqDomain=" + this.getReqDomain() + ", consumerGroupForEventBus=" + this.getConsumerGroupForEventBus() + ", query=" + this.getQuery() + ")";
    }
}

