/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.ingetration.AdxCounterServiceIntegration;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.exchange.ExchangeContext;
import com.bxm.adx.common.market.exchange.ExchangeParam;
import com.bxm.adx.common.micrometer.BuyerMeter;
import com.bxm.adx.common.openlog.event.internal.AdxRequestEvent;
import com.bxm.adx.common.openlog.event.internal.DspBidEvent;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Geo;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.adxcounter.facade.constant.AdxMtEnum;
import com.bxm.adxcounter.facade.model.AdxCounterDTO;
import com.bxm.mcssp.common.enums.app.DockingMethodTypeEnum;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ExchangeCallable
implements Callable<Deal> {
    private static final Logger log = LoggerFactory.getLogger(ExchangeCallable.class);
    private final Buyer buyer;
    private final BidRequest bidRequest;
    private final AdxCounterServiceIntegration service;
    private final BuyerMeter buyerMeter;
    private final ExchangeParam exchangeParam;
    private final EventPark eventPark;

    public ExchangeCallable(Buyer buyer, BidRequest bidRequest, AdxCounterServiceIntegration service, BuyerMeter buyerMeter, ExchangeParam exchangeParam, EventPark eventPark) {
        this.buyer = buyer;
        this.bidRequest = bidRequest;
        this.service = service;
        this.buyerMeter = buyerMeter;
        this.exchangeParam = exchangeParam;
        this.eventPark = eventPark;
    }

    private void dot(List<AdxCounterDTO> dtos, Integer mt) {
        for (AdxCounterDTO dto : dtos) {
            try {
                dto.setMt(mt);
                this.service.counter(dto);
            }
            catch (Exception e) {
                log.warn("counter: ", (Throwable)e);
            }
        }
    }

    private List<AdxCounterDTO> build(BidRequest request, Buyer buyer) {
        ArrayList dtos = Lists.newArrayList();
        List<Impression> imps = request.getImps();
        for (Impression imp : imps) {
            Device device = request.getDevice();
            AdxCounterDTO dto = new AdxCounterDTO();
            dto.setT(Objects.toString(System.currentTimeMillis()));
            dto.setIp(device.getIp());
            dto.setUa(device.getUa());
            dto.setMac(device.getMac());
            dto.setOs(device.isAndroid() ? "1" : (device.isIos() ? "2" : "0"));
            dto.setImei(device.getImei());
            dto.setImei_md5(device.getImei_md5());
            dto.setAnid(device.getDpid());
            dto.setAnid_md5(device.getDpid_md5());
            dto.setOaid(device.getOaid());
            dto.setIdfa(device.getIdfa());
            dto.setIdfa_md5(device.getIdfa_md5());
            dto.setDevb(null);
            dto.setDevm(null);
            dto.setNet(this.getNet(device));
            Geo geo = device.getGeo();
            if (Objects.nonNull(geo)) {
                dto.setLon(Objects.toString(geo.getLon()));
                dto.setLat(Objects.toString(geo.getLat()));
            }
            dto.setBidid(request.getId());
            dto.setTagid(imp.getTag_id());
            Dsp dsp = buyer.getDsp();
            if (Objects.isNull(dsp)) continue;
            dto.setDspid(Objects.toString(dsp.getId()));
            dto.setCreateid(null);
            dto.setWin(null);
            dto.setStatus(null);
            dto.setActid(null);
            dto.setScene(null);
            dtos.add(dto);
        }
        return dtos;
    }

    private String getNet(Device device) {
        Integer connectionType = device.getConnection_type();
        return Objects.toString(connectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deal call() {
        String name = this.buyer.getCode();
        BuyModelAdapter modelAdapter = this.buyer.getModelAdapter();
        if (null == modelAdapter) {
            log.warn("BuyModelAdapter [{}] not found!", (Object)name);
            return null;
        }
        List<AdxCounterDTO> counterDTOS = this.build(this.bidRequest, this.buyer);
        byte[] request = null;
        try {
            this.dot(counterDTOS, AdxMtEnum._102.getOriginal());
            ExchangeContext.putBidRequest(this.bidRequest);
            ExchangeContext.putBuyer(this.buyer);
            ExchangeContext.putDispatchConfig(this.exchangeParam.getDispatcherConfigId());
            Dispatcher dispatcher = this.exchangeParam.getDispatcher();
            ExchangeContext.putDispatch(dispatcher);
            BidRequest adxRequest = this.rebuildBidRequest(this.exchangeParam);
            ExchangeContext.putAdxRequest(adxRequest);
            request = modelAdapter.buildRequest(adxRequest);
            if (ArrayUtils.isEmpty((byte[])request)) {
                Deal deal = null;
                return deal;
            }
            Dsp dsp = this.buyer.getDsp();
            String configId = "";
            if (Objects.nonNull(dispatcher) && Objects.nonNull(dispatcher.getConfigId())) {
                configId = dispatcher.getConfigId().toString();
            }
            this.eventPark.post((EventObject)new AdxRequestEvent(this, this.bidRequest, adxRequest, dsp.getId().toString(), configId));
            this.buyerMeter.increaseRequest(this.buyer);
            byte[] response = this.offer(request);
            if (ArrayUtils.isEmpty((byte[])response)) {
                throw new AdxException(AdxErrEnum.DSP_EMPTY_RESPONSE);
            }
            Deal deal = new Deal(this.buyer, request, response, this.bidRequest, adxRequest);
            if (!deal.isBidSuccess()) {
                throw new AdxException(AdxErrEnum.DSP_EMPTY_RESPONSE);
            }
            this.rebuildResponse(deal, this.exchangeParam, dsp);
            this.eventPark.post((EventObject)new DspBidEvent(this, this.bidRequest, adxRequest, deal.getBidResponse(), dsp.getId().toString()));
            this.buyerMeter.increasePadding(this.buyer);
            this.dot(counterDTOS, AdxMtEnum._103.getOriginal());
            Deal deal2 = deal;
            return deal2;
        }
        catch (AdxException e) {
            AdxErrEnum adxErrEnum = Optional.ofNullable(e.getAdxErrEnum()).orElse(AdxErrEnum.UNKNOWN_ERR);
            Deal deal = new Deal(this.buyer, request, this.bidRequest, adxErrEnum);
            return deal;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("deal call err", (Throwable)e);
            }
            Deal deal = null;
            return deal;
        }
        finally {
            ExchangeContext.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] offer(byte[] request) {
        byte[] response;
        long start = System.nanoTime();
        try {
            response = this.buyer.offer(request);
        }
        finally {
            this.buyerMeter.recordRequest(this.buyer, start);
        }
        return response;
    }

    private BidRequest rebuildBidRequest(ExchangeParam exchangeParam) {
        BidRequest adxRequest = new BidRequest();
        BeanUtils.copyProperties((Object)this.bidRequest, (Object)adxRequest);
        Dispatcher dispatcher = exchangeParam.getDispatcher();
        List<Impression> impressions = adxRequest.getImps();
        Integer dockingMethodType = adxRequest.getDockingMethodType();
        ArrayList<Impression> newImpressions = new ArrayList<Impression>();
        for (Impression impression : impressions) {
            Impression newImpression = new Impression();
            BeanUtils.copyProperties((Object)impression, (Object)newImpression);
            if (Objects.nonNull(dockingMethodType) && dockingMethodType == DockingMethodTypeEnum.SDK_OPERATION.getType()) {
                if (!this.buyer.getCode().equalsIgnoreCase("scene")) {
                    newImpression.setTag_id(dispatcher.getDspPosid());
                }
            } else {
                newImpression.setTag_id(dispatcher.getDspPosid());
            }
            BigDecimal dspBasePrice = dispatcher.getDspBasePrice();
            if (Objects.nonNull(dspBasePrice) && dspBasePrice.compareTo(BigDecimal.ZERO) > 0) {
                newImpression.setBid_floor(dispatcher.getDspBasePrice().movePointRight(2));
            }
            if (Objects.isNull(newImpression.getBid_floor())) {
                newImpression.setBid_floor(BigDecimal.ZERO);
            }
            newImpression.setBid_floor(newImpression.getBid_floor().setScale(0, 0));
            newImpressions.add(newImpression);
        }
        adxRequest.setImps(newImpressions);
        App app = new App();
        if (Objects.nonNull(adxRequest.getApp())) {
            BeanUtils.copyProperties((Object)adxRequest.getApp(), (Object)app);
        }
        if (Objects.nonNull(dockingMethodType) && dockingMethodType == DockingMethodTypeEnum.API_OPERATION.getType()) {
            app.setId(dispatcher.getDspAppid());
            app.setBundle(dispatcher.getAppPackageName());
        }
        adxRequest.setApp(app);
        return adxRequest;
    }

    private void rebuildResponse(Deal deal, ExchangeParam exchangeParam, Dsp dsp) {
        if (deal.isOp()) {
            return;
        }
        BidResponse bidResponse = deal.getBidResponse();
        BidRequest bidRequest = deal.getBidRequest();
        Dispatcher dispatcher = exchangeParam.getDispatcher();
        if (StringUtils.isEmpty((String)bidResponse.getId())) {
            bidResponse.setId(bidRequest.getId());
        }
        boolean isRtb = this.isRtb(dsp);
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            seatBid.setDspId(dispatcher.getDspId());
            seatBid.setConfigId(dispatcher.getConfigId());
            for (Bid bid : seatBid.getBid()) {
                bid.setDsp_price(new BigDecimal(bid.getPrice().toString()));
                if (!isRtb) {
                    bid.setPrice(exchangeParam.getDispatcher().getDspAvgPrice().movePointRight(2));
                }
                if (isRtb && Objects.nonNull(dispatcher.getProfitMargin())) {
                    BigDecimal price = bid.getPrice();
                    price = price.multiply(new BigDecimal(100).subtract(dispatcher.getProfitMargin())).movePointLeft(2);
                    bid.setPrice(price);
                }
                bid.setPrice(bid.getPrice().setScale(0, 1));
                bid.setDsp_appid(exchangeParam.getDispatcher().getDspAppid());
            }
        }
    }

    private boolean isRtb(Dsp dsp) {
        Integer settleType;
        return Objects.nonNull(dsp) && Objects.nonNull(settleType = dsp.getSettleType()) && settleType == AdxConstants.SettleType.REAL_TIME_RTB.getType();
    }
}

