/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.mcssp.common.enums.app.DockingMethodTypeEnum;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;

@Order(value=0x7FFFFFFF)
@Configuration
public class PriceLowerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PriceLowerFilter.class);

    @Override
    public void filter(List<Deal> deals) {
        HashMap higher = Maps.newHashMap();
        String key = "higher";
        deals.removeIf(deal -> {
            BidResponse response = deal.getBidResponse();
            if (null == response) {
                return true;
            }
            List<SeatBid> seatBids = response.getSeat_bid();
            if (org.apache.commons.collections.CollectionUtils.isEmpty(seatBids)) {
                return true;
            }
            seatBids.removeIf(seatBid -> {
                List<Bid> bidList = seatBid.getBid();
                if (org.apache.commons.collections.CollectionUtils.isEmpty(bidList)) {
                    return true;
                }
                bidList.removeIf(b -> {
                    BigDecimal price = b.getPrice();
                    if (null == price) {
                        return true;
                    }
                    BidRequest request = deal.getBidRequest();
                    BigDecimal bidFloor = null;
                    if (Objects.nonNull(request.getDockingMethodType()) && DockingMethodTypeEnum.API_OPERATION.getType() == request.getDockingMethodType()) {
                        bidFloor = request.getImps().iterator().next().getBid_floor();
                    }
                    if (Objects.nonNull(bidFloor) && price.compareTo(bidFloor) < 0) {
                        return true;
                    }
                    BigDecimal max = null;
                    if (CollectionUtils.isEmpty((Map)higher)) {
                        MapHelper.get(higher, key, price);
                        return false;
                    }
                    max = MapHelper.get(higher, key, price);
                    if (price.compareTo(max) > 0) {
                        higher.put(key, price);
                        return false;
                    }
                    return true;
                });
                return org.apache.commons.collections.CollectionUtils.isEmpty(bidList);
            });
            return org.apache.commons.collections.CollectionUtils.isEmpty(seatBids);
        });
    }

    public static void main(String[] args) {
        System.out.println(Float.compare(0.0f, 0.0f));
        System.out.println(Float.compare(1.0f, 0.0f));
        System.out.println(Float.compare(0.0f, 1.0f));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

