/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sdkrounds;

import com.bxm.adx.common.ingetration.UserServiceIntegration;
import com.bxm.adx.common.sdkrounds.SdkRoundsDao;
import com.bxm.adx.common.sdkrounds.SdkRoundsRequest;
import com.bxm.adx.common.sdkrounds.SdkRoundsResponse;
import com.bxm.adx.common.sdkrounds.SdkRoundsService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.mccms.facade.model.pushable.PositionSdkRoundsCacheVO;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SdkRoundsServiceImpl
implements SdkRoundsService {
    private static final Logger log = LoggerFactory.getLogger(SdkRoundsServiceImpl.class);
    private final SdkRoundsDao sdkRoundsDao;
    private final PositionService positionService;
    private final UserServiceIntegration userService;

    public SdkRoundsServiceImpl(SdkRoundsDao sdkRoundsDao, PositionService positionService, UserServiceIntegration userService) {
        this.sdkRoundsDao = sdkRoundsDao;
        this.positionService = positionService;
        this.userService = userService;
    }

    @Override
    public SdkRoundsResponse getByPositionId(SdkRoundsRequest sdkRoundsRequest) {
        SdkRoundsResponse sdkRoundsResponse = new SdkRoundsResponse();
        String positionId = sdkRoundsRequest.getPositionId();
        Position position = this.positionService.getByPositionId(positionId);
        if (null == position) {
            if (log.isDebugEnabled()) {
                log.debug("\u5e7f\u544a\u4f4dSDK\u8f6e\u6b21\u4e2d\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\uff1a{} \u7684\u5e7f\u544a\u4f4d\u4fe1\u606f\u3002", (Object)positionId);
            }
            return sdkRoundsResponse;
        }
        List<PositionSdkRoundsCacheVO> list = this.sdkRoundsDao.getByPositionId(positionId);
        if (CollectionUtils.isEmpty(list)) {
            if (log.isDebugEnabled()) {
                log.debug("\u5e7f\u544a\u4f4dSDK\u8f6e\u6b21\u4e2d\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\uff1a{} \u7684\u5e7f\u544a\u4f4d\u7684\u8f6e\u6b21\u4fe1\u606f\u3002", (Object)positionId);
            }
            return sdkRoundsResponse;
        }
        sdkRoundsResponse.setPositionId(positionId);
        sdkRoundsResponse.setSdkRoundsList(list);
        return sdkRoundsResponse;
    }
}

