package com.bxm.adx.common.openlog;

import java.util.Collection;

import org.springframework.context.annotation.Configuration;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.openlog.event.external.AdShowEvent;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Adx;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventBusBean;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventConfig;
import com.bxm.warcar.integration.eventbus.EventPark;

/**
 * @author zhengwangeng
 * @date 2022-06-14
 * @since 1.0
 */
@Configuration
public class DefaultAdxOpenLogEventBusBean implements OpenLogEventBusBean {

    private final AdxProperties properties;
    private final EventPark eventPark;

    public DefaultAdxOpenLogEventBusBean(AdxProperties properties, EventPark eventPark) {
        this.properties = properties;
        this.eventPark = eventPark;
    }

    @Override
    public String getId() {
        return properties.getOpenLog().getConsumerGroupForEventBus();
    }

    @Override
    public Production getProduction() {
        return Production.ADX;
    }

    @Override
    public EventPark getEventPark() {
        return eventPark;
    }

    @Override
    public void bindTo(Collection<OpenLogEventConfig> registry) {
        registry.add(OpenLogEventConfig.builder().mt(Adx.Mt.Show.original()).eventType(AdShowEvent.class).build());
    }

}
