package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 广告优化dsp
 *
 * @author fgf
 * @date 2022/4/2
 **/
@Slf4j
@Configuration
public class OptimizationFilter implements Filter {
    @Override
    public void filter(List<Deal> deals) {
        if (AdxContextFactory.get().isOptimization()) {
            deals.removeIf(
                    deal -> {
                        if (deal.isOp()) {
                            BidResponse bidResponse = deal.getBidResponse();
                            if (Objects.nonNull(bidResponse)) {
                                List<Bid> bids = bidResponse.getSeat_bid().stream()
                                        .map(SeatBid::getBid)
                                        .flatMap(Collection::stream)
                                        .collect(Collectors.toList());
                                for (Bid bid : bids) {
                                    if (Objects.nonNull(bid)) {
//                                        if (StringUtils.isEmpty(bid.getDeep_link_url())) {
                                            List<String> urls = bid.getImp_monitors().stream()
                                                    .map(ImpMonitor::getImp_monitor_url)
                                                    .collect(Collectors.toList());
                                            AdxContextFactory.get().setOptimizationImpUrls(urls);
                                            break;
//                                        }
                                    }
                                }
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
            );
        }
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
