package com.bxm.adx.common.sell.position;

import com.bxm.adx.common.sell.position.verify.*;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.req.App;
import com.bxm.mccms.facade.model.pushable.PositionInteractAppentranceRefCacheVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @since 2019-12-18
 */
@Configuration
@Slf4j
public class PositionServiceImpl implements PositionService, CommandLineRunner {
    private final PositionDao positionDao;
    private final SpecialAppIdVerify specialAppIdVerify;
    private final InnerPackageNameVerify innerPackageNameVerify;
    private final AppVerify appVerify;

    public PositionServiceImpl(PositionDao positionDao, SpecialAppIdVerify specialAppIdVerify,
                               InnerPackageNameVerify innerPackageNameVerify, AppVerify appVerify) {
        this.positionDao = positionDao;
        this.specialAppIdVerify = specialAppIdVerify;
        this.innerPackageNameVerify = innerPackageNameVerify;
        this.appVerify = appVerify;
    }

    @Override
    public Position getByAppPositionId(String appPositionId) {
        return positionDao.getByAppPositionId(appPositionId);
    }

    @Override
    public Position getByPositionId(String positionId) {
        //TODO 这里有可能传的是appPositionId
        Position position = getByPositionIdNativeCache(positionId);
        if (position == null) {
            position = getByAppPositionIdNativeCache(positionId);
        }
        return position;
    }

    @Override
    public boolean verifyPosition(Position position, SspRequest sspRequest) {
        App app = sspRequest.getApp();
        if (app == null) {
            if (log.isWarnEnabled()) {
                log.warn("app is null");
            }
            return false;
        }
        Context context = new Context();
        context.setResult(false);
        context.setPosition(position);
        context.setAppId(app.getId());
        context.setPackageName(app.getBundle());
        context.setSdkVer(sspRequest.getVer());
        specialAppIdVerify.doVerify(context);
        return context.isResult();
    }

    @Override
    public boolean verifyPosition(Position position, String appId, String packageName, String sdkVer) {
        Context context = new Context();
        context.setResult(false);
        context.setPosition(position);
        context.setAppId(appId);
        context.setPackageName(packageName);
        context.setSdkVer(sdkVer);
        specialAppIdVerify.doVerify(context);
        return context.isResult();
    }

    @Override
    public PositionInteractAppentranceRefCacheVO getInteractByPositionId(String positionId) {
        return positionDao.getInteractByPositionId(positionId);
    }

    @Override
    public Position getByPositionIdNativeCache(String positionId) {
        return positionDao.getByPositionIdNativeCache(positionId);
    }

    @Override
    public Position getByAppPositionIdNativeCache(String appPositionId) {
        return positionDao.getByAppPositionIdNativeCache(appPositionId);
    }

    @Override
    public Position getByPositionId(String appId, Integer w, Integer h, Integer positionType, String appPositionId) {
        return positionDao.getByPositionId(appId, w, h, positionType, appPositionId);
    }

    @Override
    public void run(String... args) throws Exception {
        specialAppIdVerify.setNextVerify(innerPackageNameVerify);
        innerPackageNameVerify.setNextVerify(appVerify);
    }
}
