package com.bxm.adx.common.buy.cache;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.user.facade.DevRequest;
import com.bxm.user.id.generator.DeviceHelper;
import com.bxm.user.id.generator.DeviceInfo;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2022/7/6
 **/
public interface ResponseCache {

    /**
     * 缓存response
     *
     * @param bidRequest
     * @param bidResponse
     * @param buyer
     */
    void saveResponse(BidRequest bidRequest, BidResponse bidResponse, Buyer buyer);

    /**
     * 获取response
     *
     * @param bidRequest
     * @param buyer
     * @return
     */
    BidResponse getResponse(BidRequest bidRequest, BuyerWrapper buyer);

    /**
     * 填充DealList
     *
     * @param forCache
     */
    List<Deal> getCacheDealList(Map<BuyerWrapper, BidRequest> forCache);

    /**
     * 移除response
     *
     * @param deal
     */
    void removeResponse(Deal deal);

    /**
     * 构建缓存rediskey
     *
     * @param bidRequest
     * @param buyer
     * @return
     */
    default KeyGenerator buildKey(BidRequest bidRequest, Buyer buyer) {
        Long dspId = buyer.getDsp().getId();
        Impression impression = bidRequest.getImps().iterator().next();
        String dspTagId = impression.getTag_id();
        Device device = bidRequest.getDevice();
        String uid = getUid(device);
        if (StringUtils.isEmpty(uid)) {
            return null;
        } else {
            return CacheKeys.getResponseCacheKey(dspId.toString(), dspTagId, uid);
        }
    }

    default KeyGenerator buildKey(BidRequest bidRequest, Buyer buyer, Dispatcher dispatcher) {
        Long dspId = buyer.getDsp().getId();
//        Impression impression = bidRequest.getImps().iterator().next();
//        String dspTagId = impression.getTag_id();
        String dspTagId = dispatcher.getDspPosid();
        Device device = bidRequest.getDevice();
        String uid = getUidNotEmpty(device);
        if (StringUtils.isEmpty(uid)) {
            return null;
        } else {
            return CacheKeys.getResponseCacheKey(dspId.toString(), dspTagId, uid);
        }
    }

    default String getUidNotEmpty(Device device) {
        if (!StringUtils.isEmpty(device.getOaid())) {
            return device.getOaid();
        }
        if (!StringUtils.isEmpty(device.getOaid_md5())) {
            return device.getOaid_md5();
        }
        if (!StringUtils.isEmpty(device.getImei())) {
            return device.getImei();
        }
        if (!StringUtils.isEmpty(device.getImei_md5())) {
            return device.getImei_md5();
        }
        if (!StringUtils.isEmpty(device.getIdfa())) {
            return device.getIdfa();
        }
        if (!StringUtils.isEmpty(device.getIdfa_md5())) {
            return device.getIdfa_md5();
        }
        if (!StringUtils.isEmpty(device.getDpid())) {
            return device.getDpid();
        }
        if (!StringUtils.isEmpty(device.getDpid_md5())) {
            return device.getDpid_md5();
        }
        return null;
    }

    default String getUid(Device device) {
        if (Objects.nonNull(device.getOaid())) {
            return device.getOaid();
        }
        if (Objects.nonNull(device.getOaid_md5())) {
            return device.getOaid_md5();
        }
        if (Objects.nonNull(device.getImei())) {
            return device.getImei();
        }
        if (Objects.nonNull(device.getImei_md5())) {
            return device.getImei_md5();
        }
        if (Objects.nonNull(device.getIdfa())) {
            return device.getIdfa();
        }
        if (Objects.nonNull(device.getIdfa_md5())) {
            return device.getIdfa_md5();
        }
        if (Objects.nonNull(device.getDpid())) {
            return device.getDpid();
        }
        if (Objects.nonNull(device.getDpid_md5())) {
            return device.getDpid_md5();
        }
        return null;
    }
}
