package com.bxm.adx.common.plugin;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.warcar.dpl2.PluginBus;
import com.bxm.warcar.dpl2.plugin.Plugin;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.annotation.Configuration;

import java.util.Iterator;
import java.util.Map;

/**
 * @author allen
 * @since 2019-12-12
 */
@Slf4j
@Configuration
public class PluginHolder {

    private final PluginBus pluginBus;

    public PluginHolder(PluginBus pluginBus) {
        this.pluginBus = pluginBus;
    }

    public <T> T getService(String name, Class<T> clazz) {
        Plugin plugin = pluginBus.lookup(name);
        if (null == plugin) {
            log.warn("Not found Plugin for name: {}", name);
            return null;
        }
        return plugin.getService(clazz);
    }

    public Map<String, Buyer> getBuyers() {
        Map<String, Buyer> buyers = Maps.newHashMap();
        Iterator<Plugin> plugins = pluginBus.getAllPlugins();
        while (plugins.hasNext()) {
            Plugin next = plugins.next();
            String name = next.getConfig().getKey();
            Buyer buyer = null;
            try {
                buyer = next.getService(Buyer.class);
            } catch (NoSuchBeanDefinitionException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Plugin {} is a entrance plugin", name);
                }
            }
            if (null != buyer) {
                buyers.put(name, buyer);
            }
        }
        return buyers;
    }
}
