package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.SspResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * Created by Arei on 2020/4/10.
 */
@Component
@Slf4j
public class Interpreter {

    private AdxRequestBuilder adxRequestBuilder;

    private SspResponseBuilder sspResponseBuilder;

    public Interpreter(AdxRequestBuilder adxRequestBuilder, SspResponseBuilder sspResponseBuilder) {
        this.adxRequestBuilder = adxRequestBuilder;
        this.sspResponseBuilder = sspResponseBuilder;
    }

    public void translate(SspRequest sspRequest, BidRequest request) {
        adxRequestBuilder.buildId(sspRequest, request);
        adxRequestBuilder.buildAdxType(sspRequest, request);
        adxRequestBuilder.buildImps(sspRequest, request);
        adxRequestBuilder.buildcType(sspRequest, request);
        adxRequestBuilder.buildApp(sspRequest, request);
        adxRequestBuilder.buildDevice(sspRequest, request);
        adxRequestBuilder.buildUser(sspRequest, request);
        adxRequestBuilder.buildGeo(sspRequest, request);
        adxRequestBuilder.buildCur(sspRequest, request);
        adxRequestBuilder.buildBidType(sspRequest, request);
        adxRequestBuilder.buildAt(sspRequest, request);
        adxRequestBuilder.buildDealIds(sspRequest, request);
        adxRequestBuilder.buildBillType(sspRequest, request);
        adxRequestBuilder.buildTest(sspRequest, request);
        adxRequestBuilder.buildtMax(sspRequest, request);
        adxRequestBuilder.buildbCat(sspRequest, request);
        adxRequestBuilder.buildbSeat(sspRequest, request);
        adxRequestBuilder.buildwSeat(sspRequest, request);
        adxRequestBuilder.buildbAdv(sspRequest, request);
        adxRequestBuilder.buildbApp(sspRequest, request);
        adxRequestBuilder.buildExt(sspRequest, request);
        adxRequestBuilder.buildAdType(sspRequest, request);
        adxRequestBuilder.buildSdkVer(sspRequest, request);
        adxRequestBuilder.buildRequestModel(sspRequest, request);
    }

    public void translate(BidResponse bidResponse, BidRequest bidRequest, SspResponse sspResponse) {
        sspResponseBuilder.buildResult(bidResponse, sspResponse);
        sspResponseBuilder.buildMsg(bidResponse, sspResponse);
        sspResponseBuilder.buildAds(bidResponse, bidRequest, sspResponse);
    }
}
