package com.bxm.adx.common.buy.dispatcher.control;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.google.common.collect.Sets;
import org.springframework.context.annotation.Configuration;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author fgf
 * @date 2022/12/23
 **/
@Configuration
public class AlgoFlowControlCached implements AlgoFlowControlChangeHandler {
    /**
     * 算法流量控制配置集合
     * <pre>
     * |-----------------------|-------------------------------|
     * |    Key                | Value                         |
     * |-----------------------|-------------------------------|
     * | {positionId-dspId-dspPosId} | [bundle1, bundle2,...]|
     * |-----------------------|-------------------------------|
     * </pre>
     */
    private final ConcurrentHashMap<String, Set<String>> algoFlowControlMap = new ConcurrentHashMap<>();

    @Override
    public void doUpdate(AlgoFlowControl old, AlgoFlowControl latest) {
        if (isExecuteUpdateAndDoDelete(old, latest)) {
            algoFlowControlMap.put(latest.getUniqueKey(), Sets.newHashSet(latest.getValue().split(",")));
        }
    }

    @Override
    public void doDelete(AlgoFlowControl old) {
        algoFlowControlMap.remove(old.getUniqueKey());
    }

    public Set<String> getAlgoControlBundles(Dispatcher dispatcher) {
        String key = getKeyByDispatcher(dispatcher);
        return algoFlowControlMap.get(key);
    }

    private String getKeyByDispatcher(Dispatcher dispatcher) {
        String positionId = dispatcher.getPositionId();
        Long dspId = dispatcher.getDspId();
        String dspPosId = dispatcher.getDspPosid();
        return positionId + "-" + dspId + "-" + dspPosId;
    }
}
