package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.buy.dispatcher.control.AlgoFlowControl;
import com.bxm.adx.common.buy.dispatcher.control.AlgoFlowControlCaching;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointCaching;
import com.bxm.adx.common.caching.sync.DataSyncHandler;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2022/11/29
 **/
@Configuration
public class AlgoFlowControlDataSyncHandler implements DataSyncHandler {
    private final AlgoFlowControlCaching algoFlowControlCaching;

    public AlgoFlowControlDataSyncHandler(AlgoFlowControlCaching algoFlowControlCaching) {
        this.algoFlowControlCaching = algoFlowControlCaching;
    }

    @Override
    public Class<?> getClazz() {
        return AlgoFlowControl.class;
    }

    @Override
    public Object set(String key, Object object) {
        AlgoFlowControl algoFlowControl = (AlgoFlowControl) object;
        algoFlowControlCaching.set(algoFlowControl.getUniqueKey(), algoFlowControl);
        return object;
    }
}
