package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.adx.common.creative.replace.ReplaceCreative;
import com.bxm.adx.common.creative.replace.ReplaceCreativeCaching;
import com.bxm.mccms.facade.model.adx.AdxReplaceCreativeFacadeDTO;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2022/12/7
 **/
@Configuration
public class ReplaceCreativeDataSyncHandler implements DataSyncHandler {
    private final ReplaceCreativeCaching replaceCreativeCaching;

    public ReplaceCreativeDataSyncHandler(ReplaceCreativeCaching replaceCreativeCaching) {
        this.replaceCreativeCaching = replaceCreativeCaching;
    }

    @Override
    public Class<?> getClazz() {
        return AdxReplaceCreativeFacadeDTO.class;
    }

    @Override
    public Object set(String key, Object object) {
        AdxReplaceCreativeFacadeDTO creativeFacadeDTO = (AdxReplaceCreativeFacadeDTO) object;
        ReplaceCreative replaceCreative = new ReplaceCreative();
        BeanUtils.copyProperties(creativeFacadeDTO, replaceCreative);
        replaceCreativeCaching.set(String.valueOf(replaceCreative.getId()), replaceCreative);
        return object;
    }
}
