package com.bxm.adx.common.collection;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 广告位集合请求类<br/>
 *
 * @author zhengwangeng
 * @since 2021-9-27
 */
@Data
public class PositionCollectionRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告位ID
     */
    @NotBlank(message = "广告位ID不能为空")
    private String positionId;

    /**
     * 广告位场景
     */
    @NotNull(message = "广告位场景不能为空")
    private Byte positionScene;

    /**
     * 系统类型，1：安卓，2：IOS
     */
    private Integer os;

}
