package com.bxm.adx.common.creative.replace;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author fgf
 * @date 2022/11/22
 **/
@Data
public class ReplaceCreative {
    public static final int TYPE_IMG = 1;
    public static final int TYPE_VIDEO = 2;
    /**
     * 主键
     */
    private Long id;

    /**
     * 素材类型 1 图片 2 视频
     */
    private Integer type;

    /**
     * 广告名称
     */
    private String name;

    /**
     * 广告标题
     */
    private String title;

    /**
     * 广告内容(广告描述)
     */
    private String content;

    /**
     * 广告来源
     */
    private String source;

    /**
     * icon链接
     */
    private String iconUrl;

    /**
     * icon格式
     */
    private String iconFormat;

    /**
     * icon尺寸
     */
    private String iconSize;

    /**
     * icon 大小
     */
    private BigDecimal iconKb;

    /**
     * 图片链接
     */
    private String imageUrl;

    /**
     * 图片格式
     */
    private String imageFormat;

    /**
     * 图片尺寸
     */
    private String imageSize;

    /**
     * 图片大小
     */
    private BigDecimal imageKb;

    /**
     * 视频链接
     */
    private String videoUrl;

    /**
     * 视频格式
     */
    private String videoFormat;

    /**
     * 视频尺寸
     */
    private String videoSize;

    /**
     * 视频大小
     */
    private BigDecimal videoKb;

    /**
     * 视频时长
     */
    private Integer videoTime;

    /**
     * 视频码率
     */
    private Integer videoCodeRate;
}
