package com.bxm.adx.common.ingetration.empty;

import com.bxm.adx.common.ingetration.UserServiceIntegration;
import com.bxm.user.facade.DevRequest;
import com.bxm.user.facade.SdkInitCache;
import com.bxm.user.facade.UserProfile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import java.util.List;

/**
 * @author allen
 * @date 2020-11-17
 * @since 1.0
 */
@Configuration
@Profile("standalone")
public class EmptyUserServiceIntegrationImpl implements UserServiceIntegration {

    @Override
    public UserProfile getUser(DevRequest request) {
        UserProfile userProfile = new UserProfile();
        userProfile.setUid(DigestUtils.md5Hex(ToStringBuilder.reflectionToString(request, ToStringStyle.SIMPLE_STYLE)));
        return userProfile;
    }

    @Override
    public SdkInitCache getSdkInit(DevRequest request) {
        return null;
    }

    @Override
    public SdkInitCache getSdkInitByUid(String uid) {
        return null;
    }

    @Override
    public List<String> getInstalledList(DevRequest request) {
        return null;
    }

    @Override
    public List<String> getInstalledListByUid(String uid) {
        return null;
    }

    @Override
    public String getCuid(String appId, String uid) {
        return null;
    }
}
