package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import static com.bxm.adx.common.AdxConstants.BidModel;
/**
 * bidModel适配价格配置
 * @author fgf
 * @date 2024/9/13
 **/
@Slf4j
@Configuration
public class BidModelDispatcherPriceConfigFilter implements DispatcherPriceConfigFilter {
    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        int bidModel = attribute.getBidRequest().getBid_model();
        priceConfigs.removeIf(priceConfig -> {
            return !checkMediaCostTypeByBidModel(bidModel, priceConfig);
        });
    }

    private boolean checkMediaCostTypeByBidModel(int bidModel, DispatcherPriceConfig config) {
        Integer mediaCostType = config.getMediaCostType();
        switch (bidModel) {
            case BidModel.SUPPORT_CPM:
                return AdxConstants.ChargeType.CPM == mediaCostType;
            case BidModel.SUPPORT_CPC:
                return AdxConstants.ChargeType.CPC == mediaCostType;
//            case BidModel.CTR:
            case BidModel.CPM_CPC:
                return AdxConstants.ChargeType.CPC == mediaCostType || AdxConstants.ChargeType.CPM == mediaCostType;
            case BidModel.CPM_CPC_OCPM:
                return AdxConstants.ChargeType.CPC == mediaCostType || AdxConstants.ChargeType.CPM == mediaCostType || AdxConstants.ChargeType.OCPM == mediaCostType;
            default:
                log.warn("unsupport bidmodel");
        }
        return false;
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
