package com.bxm.adx.common.market.exchange.rebuild.filter;

import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferFactory;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.warcar.integration.pair.Pair;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.*;

/**
 * 根据出价选出出价最高的配置
 * @author jingyu.li
 * @date 2024-06-11
 */
@Slf4j
@Configuration
public class BidPriceTop1DispatcherPriceConfigFilter implements DispatcherPriceConfigFilter{

    private final OfferFactory factory;
    private final Pair pair;
    // 默认策略的广告位 id
    private static final String KEY = "adx.default.strategy.position.id";


    public BidPriceTop1DispatcherPriceConfigFilter(OfferFactory factory, Pair pair) {
        this.factory = factory;
        this.pair = pair;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        if (priceConfigs.size() == 1) {
            return;
        }

        // todo 这一步计算出价有问题，因为dsp赢价还没计算，获取dsp赢价为空，暂时改成随机出自定义配置
        //
        Set<String> positionIds = pair.get(KEY).ofHashSet();
        if (CollectionUtils.isNotEmpty(positionIds)) {
            String bxmTagId = attribute.getBidRequest().getBxmTagId();
            if (!positionIds.contains(bxmTagId)) {
                priceConfigs.removeIf(config -> "默认出价策略".equals(config.getPriceModeName()));
            }
        }

//        priceConfigs.removeIf(config -> "默认出价策略".equals(config.getPriceModeName()));

        if (priceConfigs.size() > 1) {
            List<DispatcherPriceConfig> dispatcherPriceConfigs = new ArrayList<>(priceConfigs);
            DispatcherPriceConfig dispatcherPriceConfig = dispatcherPriceConfigs.get(RandomUtil.randomInt(priceConfigs.size()));
            priceConfigs.clear();
            priceConfigs.add(dispatcherPriceConfig);
        }

//        //根据list选出top1，再根据top1从map里获取具体出价
//        Map<OfferResult, DispatcherPriceConfig> map = new HashMap<>();
//        //排序用
//        List<OfferResult> offerResults = new ArrayList<>();
//        for (DispatcherPriceConfig priceConfig : priceConfigs) {
//            OfferResult offer = factory.offer(bid, attribute, priceConfig);
//            map.put(offer,priceConfig);
//            offerResults.add(offer);
//        }
//
//        //排序
//        offerResults.sort(Comparator.comparing(OfferResult::getOffer).reversed());
//        //获取top1出价对应的出价配置
//        OfferResult result = offerResults.get(0);
//        DispatcherPriceConfig dispatcherPriceConfig = map.get(result);
//        priceConfigs.clear();
//        priceConfigs.add(dispatcherPriceConfig);
    }
}
