package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.Objects;

/**
 * 曝光上限过滤
 * @author jingyu.li
 * @date 2024-06-11
 */
@Slf4j
@Configuration
public class MaxExposureDispatcherPriceConfigFilter implements DispatcherPriceConfigFilter{

    private final Fetcher fetcher;

    public MaxExposureDispatcherPriceConfigFilter(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public int getOrder() {
        return 30;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        priceConfigs.removeIf(config -> config.getExposureFilterMode() != null &&
                config.getExposureFilterMode() == DispatcherPriceConfig.FILTER_MODEL_WHITE &&
                getPositionDspExposure(attribute.getDispatcher(), config) >= config.getExposureValue());
    }

    /**
     * 获取已曝光次数
     *
     * @param dispatcher dsp流量分配信息
     * @return 已曝光次数
     */
    private int getPositionDspExposure(Dispatcher dispatcher,DispatcherPriceConfig config) {
        String configId = dispatcher.getConfigId().toString();
        String dspId = dispatcher.getDspId().toString();
        String dspTagId = dispatcher.getDspPosid();
        Long dpcId = config.getPriceModeId();
        if (dpcId == null) {
            log.warn("priceModeId is empty configId:{} - dspId:{} - dspTagId:{} - priceConfigId:{}",configId,dspId,dspTagId,config.getId());
        }
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getPositionDspExposure(configId, dspId, dspTagId,dpcId == null ? "" : dpcId.toString());
        Long exposure = fetcher.fetch(keyGenerator, Long.class);
        return Objects.isNull(exposure) ? 0 : exposure.intValue();
    }
}
