package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.User;
import com.bxm.warcar.integration.pair.Pair;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Set;

/**
 * 指定dsp开启透传真实已安装包名
 *
 * @author fgf
 * @date 2024/12/24
 **/
@Configuration
public class UserBuilder implements AdxBidRequestBuilder {
    private final static String KEY = "mapping.installed.app.dsp.list";
    private final static String UNLIMITED = "-1";
    private final Pair pair;

    public UserBuilder(Pair pair) {
        this.pair = pair;
    }

    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Set<String> dspIds = pair.get(KEY).ofHashSet();
        if (CollectionUtils.isEmpty(dspIds)) {
            return;
        }
        String dspId = attribute.getBuyerWrapper().getDispatcher().getDspId().toString();
        if (dspIds.contains(UNLIMITED) || dspIds.contains(dspId)) {
            User user = adxBidRequest.getUser();
            if (user == null) {
                return;
            }
            List<String> mappingList = user.getMapping_installed_app_list();
            if (CollectionUtils.isNotEmpty(mappingList)) {
                user.setInstalled_app_list(mappingList);
            }
        }
    }
}
