package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.SeatBid;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Configuration
public class SeatBidBuilder implements AdxBidResponseBuilder {

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            seatBid.setDspId(dispatcher.getDspId());
            seatBid.setDspPosid(dispatcher.getDspPosid());
            seatBid.setDspAppid(dispatcher.getDspAppid());
            seatBid.setPositionId(dispatcher.getPositionId());
            seatBid.setConfigId(dispatcher.getConfigId());
            seatBid.setStrategyId(dispatcher.getStrategyId());
            seatBid.setAlgoFlowControlBucket(dispatcher.getAlgoFlowControlBucket());
        }
    }
}
