package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ClassUtils;

import java.util.Map;

/**
 * @author fgf
 * @date 2023/3/28
 **/
@Slf4j
public class DispatcherFilterMicroMeter implements MeterBinder {
    private final Map<Class, Timer> timers = Maps.newConcurrentMap();
    private final Iterable<DispatcherFilter> filters;

    public DispatcherFilterMicroMeter(Iterable<DispatcherFilter> filters) {
        this.filters = filters;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        for (DispatcherFilter filter : filters) {
            Class<?> clazz = ClassUtils.getUserClass(filter);
            Timer timer = Timer.builder("dispatcher.filter").tag("name", clazz.getName()).register(registry);
            timers.put(clazz, timer);
            log.info("Registering Dispatcher filter {} timer meter successful.", filter);
        }
    }

    Timer get(DispatcherFilter filter) {
        return timers.get(ClassUtils.getUserClass(filter));
    }
}
