package com.bxm.adx.common.openlog.listener.external;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.adx.common.openlog.event.external.AdShowEvent;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Adx;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.integration.pair.Pair;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;

/**
 * 已曝光人群包控制
 */
@Slf4j
@Configuration
public class AdShowForCrowListener implements EventListener<AdShowEvent> {
    private final InsertExpireHandler insertExpireHandler;
    private final Pair pair;
    private static final String SHOW_CROW_CONFIG = "adx.show.crow.config";

    public AdShowForCrowListener(@Qualifier("insertExpireDeviceCrowdPackageHandler")InsertExpireHandler insertExpireHandler, Pair pair) {
        this.insertExpireHandler = insertExpireHandler;
        this.pair = pair;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdShowEvent event) {
        handleCrowLimit(event);
    }

    private void handleCrowLimit(AdShowEvent event) {
        KeyValueMap map = event.getLog();
        String tagId = map.getFirst(Adx.Param.TAGID);
        String dspId = map.getFirst(Adx.Param.DSPID);
        String crowConfig = pair.get(SHOW_CROW_CONFIG).of();
        if (StringUtils.isBlank(tagId) || StringUtils.isBlank(crowConfig)) {
            return;
        }
        ShowCrowConfig showCrowConfig = JSONUtil.toBean(crowConfig, ShowCrowConfig.class);
        if (Objects.isNull(showCrowConfig) || !showCrowConfig.getTagIdList().contains(tagId)) {
            return;
        }
        if (showCrowConfig.getEndTime() != null && !LocalDate.now().isBefore(showCrowConfig.getEndTime())) {
            return;
        }
        List<AdShowForCrowListener.CrowMapping> crowMappings = showCrowConfig.getMappingList();
        if (StringUtils.isBlank(dspId) || CollUtil.isEmpty(crowMappings)) {
            return;
        }
        for (CrowMapping mapping : crowMappings) {
            if (dspId.equals(mapping.getDspId())) {
                Device device = buildDevice(map);
                KeyGenerator key = CacheKeys.getCrowdPackageNewKey(device);
                if (Objects.nonNull(key)) {
                    // 缓存时间 单位是分钟
                    int keyExpire = 30 * 60;
                    Integer crowdExpire = showCrowConfig.getExpire();
                    if (Objects.nonNull(crowdExpire)){
                        keyExpire = crowdExpire * 60;
                    }
                    long expireTime = System.currentTimeMillis() / 1000 + keyExpire;
                    insertExpireHandler.insert(key, mapping.getCrowId(), expireTime + "", keyExpire);
                }
            }
        }
    }

    private Device buildDevice(KeyValueMap map) {
        Device device = new Device();
        device.setOaid(map.getFirst(Adx.Param.OAID));
        device.setOaid_md5(map.getFirst(Adx.Param.OAID_MD5));
        device.setImei(map.getFirst(Adx.Param.IMEI));
        device.setImei_md5(map.getFirst(Adx.Param.IMEI_MD5));
        device.setIdfa(map.getFirst(Adx.Param.IDFA));
        device.setIdfa_md5(map.getFirst(Adx.Param.IDFA_MD5));
        device.setCaid(map.getFirst("caid"));
        return device;
    }

    @Data
    private static class ShowCrowConfig{
        private List<String> tagIdList;
        private Integer expire;
        private LocalDate endTime;
        private List<CrowMapping> mappingList;
    }

    @Data
    private static class CrowMapping {
        private String dspId;
        private String crowId;
        public CrowMapping(String dspId, String crowId) {
            this.dspId = dspId;
            this.crowId = crowId;
        }
    }
}
