package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.AdxRequestEvent;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.Objects;

/**
 * @author fgf
 * @date 2022/6/1
 **/
@Configuration
public class DotAdxRequestEventListener implements EventListener<AdxRequestEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotAdxRequestEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxRequestEvent event) {
        if (Math.abs(event.getSspRequest().getId().hashCode() % 100) >= properties.getDotSimplingPercent()) {
            return;
        }
        String url = properties.getOpenLog().create(true, OpenlogConstants.Mt.ADX_REQUEST_MT, customizeParams(event), OpenlogConstants.WITHOUT_MACROS_INNER);
        BuildAttribute attribute = new BuildAttribute(OpenlogConstants.Mt.ADX_REQUEST_MT)
                .setSspRequest(event.getSspRequest())
                .setAdxRequest(event.getAdxRequest())
                .setDspId(event.getDspId())
                .setConfigId(event.getDispatcher().getConfigId())
                .setStrategyId(event.getDispatcher().getStrategyId())
                .setAlgoFlowControlBucket(event.getDispatcher().getAlgoFlowControlBucket());

        url = macrosHandler.replaceAll(url, attribute);
        openLogClient.asyncRequest(url);
    }

    private MultiValueMap<String, String> customizeParams(AdxRequestEvent event) {
        MultiValueMap<String, String> customizeParams = new LinkedMultiValueMap<>();
        BidRequest request = event.getSspRequest();
        Device device = request.getDevice();
        if (Objects.nonNull(device)) {
            String verCodeOfHms = device.getVer_code_of_hms();
            if (StringUtils.isNotBlank(verCodeOfHms)) {
                customizeParams.add(OpenlogConstants.MacrosCustomizeParams.HMS_VER, verCodeOfHms);
            }
        }
        return customizeParams;
    }
}
