package com.bxm.adx.common.sdkrounds;

import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.model.pushable.PositionSdkRoundsCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 *
 * For cache pushable
 *
 * <pre>
 * name = "POSITION_SDK_ROUNDS"
 * parameters = {positionId=$positionId}
 * byte[] = SdkRounds object to json bytes
 * </pre>
 * @author zhengwangeng
 * @since 2020-8-26
 */
@Component
@CachePush("POSITION_SDK_ROUNDS")
public class SdkRoundsDaoImpl implements SdkRoundsDao, Pushable {

    private final Fetcher fetcher;
    private final Updater updater;

    public SdkRoundsDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public List<PositionSdkRoundsCacheVO> getByPositionId(String positionId) {
        return fetcher.fetchList(getKeyGenerator(positionId), PositionSdkRoundsCacheVO.class);
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get(CachePushableFields.POSITION_ID);
        if (Objects.isNull(o)) {
            return;
        }
        String positionId = Objects.toString(o);
        List<PositionSdkRoundsCacheVO> sdkRoundsList = JsonHelper.convert(data, List.class);

        updater.remove(getKeyGenerator(positionId));
        if(CollectionUtils.isNotEmpty(sdkRoundsList)){
            updater.update(getKeyGenerator(positionId), sdkRoundsList);
        }
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build("ADX", "POSITION_SDK_ROUNDS", "POSITION_ID", value);
    }
}
