package com.bxm.adx.common.sell.bundlereplace;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author weixing
 */
@Data
public class BundleReplace implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 广告位 id
     */
    private String positionId;

    /**
     * 广告位 名称
     */
    private String positionName;

    /**
     * 开发者 id
     */
    private String developerId;

    /**
     * 开发者名称
     */
    private String developerName;

    /**
     * 广告平台 id
     */
    private String dspId;

    /**
     * 广告平台名称
     */
    private String dspName;

    /**
     * 广告端广告位 id
     */
    private String dspPosId;

    /**
     * 原包名
     */
    private String bundle;

    /**
     * 替换后包名
     */
    private String replaceBundle;

    /**
     * 替换后名称
     */
    private String replaceName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否删除,1:已删除
     */
    private Integer deleted;

    public Boolean isDeleted() {
        return Objects.nonNull(deleted) && 1 == deleted;
    }

    public String getUniqueKey() {
        return positionId + "_" + dspId + "_" + dspPosId + "_" + bundle;
    }
}
