package com.bxm.adx.common.sell.rebuild;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 抽象chain 链式执行
 *
 * @param <K>
 */
public abstract class AbstractChainHandler<K> implements ApplicationListener<ApplicationReadyEvent> {

    private final List<K> handlers = Lists.newArrayList();

    /**
     * 返回实例类型
     *
     * @return 类型
     */
    protected abstract Class<K> getInstanceClazz();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Collection<K> values = applicationContext.getBeansOfType(getInstanceClazz()).values();
        values.remove(this);
        if (CollectionUtils.isNotEmpty(values) && getInstanceClazz().isAssignableFrom(Ordered.class)) {
            values = values.stream().sorted(Comparator.comparingInt(o -> ((Ordered) o).getOrder())).collect(Collectors.toList());
        }
        handlers.addAll(values);
    }


    public List<K> getAll() {
        return handlers;
    }

}
