package com.bxm.adx.common.sell.settings;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 系统配置媒体（开发者）已安装包名
 *
 * @author fgf
 * @date 2024/12/24
 **/
@Component
@CachePush("INSTALLED_MAPPING")
@Slf4j
public class MediaInstalledAppMappingDaoImpl implements MediaInstalledAppMappingDao, Pushable {

    private final DataSyncProducer dataSyncProducer;

    public MediaInstalledAppMappingDaoImpl(DataSyncProducer dataSyncProducer) {
        this.dataSyncProducer = dataSyncProducer;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("Installed app Mapping data = {}", JsonHelper.convert(data, String.class));
        }

        MediaInstalledAppMapping mediaInstalledAppMapping = JsonHelper.convert(data, MediaInstalledAppMapping.class);
        String developerId = mediaInstalledAppMapping.getDeveloperId();
        String mediaInstalledCode = mediaInstalledAppMapping.getMediaInstalledCode();
        if (StringUtils.isEmpty(developerId) || StringUtils.isEmpty(mediaInstalledCode)) {
            return;
        }

        String key = mediaInstalledAppMapping.getClass().getName() + "$" + developerId + "$" + mediaInstalledCode;
        dataSyncProducer.post(key, mediaInstalledAppMapping);
    }
}
