package com.bxm.adx.common.sysdict;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.ConcurrentHashMap;

/**
 * @author weixing
 */
@Configuration
@Slf4j
public class SysDictCached implements SysDictChangeHandler{
    /**
     * key:typeCode_dictName value:SysDict
     */
    private final ConcurrentHashMap<String, SysDict> sysDictMap = new ConcurrentHashMap<>();
    @Override
    public void doUpdate(SysDict old, SysDict latest) {
        if (isExecuteUpdateAndDoDelete(old, latest)) {
            sysDictMap.put(latest.getUniqueKey(), latest);
        }
    }

    @Override
    public void doDelete(SysDict old) {
        sysDictMap.remove(old.getUniqueKey());
    }

    public SysDict getSysDict(String typeCode, String dictName) {
        return sysDictMap.get(getMapKey(typeCode, dictName));
    }


    private static String getMapKey(String typeCode, String dictName) {
        return typeCode + "_" + dictName;
    }
}
