package com.bxm.adx.common.sysdict;

import cn.hutool.core.util.StrUtil;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.Objects;

/**
 * @author weixing
 */
@Slf4j
@CachePush("SYS_DICT")
public class SysDictDaoImpl implements SysDictDao, Pushable {
    private final DataSyncProducer dataSyncProducer;
    private final Updater updater;

    public SysDictDaoImpl(DataSyncProducer dataSyncProducer, Updater updater) {
        this.dataSyncProducer = dataSyncProducer;
        this.updater = updater;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("sysdict data = {}", JsonHelper.convert(data, String.class));
        }

        SysDict sysDict = JsonHelper.convert(data, SysDict.class);
        if (Objects.isNull(sysDict) || Objects.isNull(sysDict.getTypeCode()) || Objects.isNull(sysDict.getDictName())) {
            return;
        }
        String typeCode = StrUtil.cleanBlank(sysDict.getTypeCode());
        // 只处理已安装包名和tanx app分类
        if ("package_name".equals(typeCode) || "tanx_category".equals(typeCode)) {
            String key = sysDict.getClass().getName() + "$" + sysDict.getUniqueKey();
            dataSyncProducer.post(key, sysDict);
        }
    }

}
