package com.bxm.adx.common;

import com.bxm.adx.common.sell.request.Caid;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author allen
 * @since 2019-12-18
 */
public class CacheKeys {
    public static KeyGenerator getBidRequestKeyGenerator(String bidid) {
        return () -> KeyBuilder.build("ADX", "POSITION", "SCENE", "BIDREQUEST", bidid);
    }

    public static KeyGenerator getActivityErrGenerator(String positionId, String type) {
        return () -> KeyBuilder.build("ADX", "SCENE", "ACTIVITY", positionId, type);
    }

    public static KeyGenerator getDspRequestCount(String dspId) {
        return () -> KeyBuilder.build("ADX", "DSP", "COUNT", "REQ", dspId);
    }

    public static KeyGenerator getDspResponseCount(String dspId) {
        return () -> KeyBuilder.build("ADX", "DSP", "COUNT", "RESP", dspId);
    }

    public static KeyGenerator getDspNowQPS(String time) {
        return () -> KeyBuilder.build("ADX", "DSP", "QPS", time);
    }

    public static KeyGenerator getDspQPSBan(String time) {
        return () -> KeyBuilder.build("ADX", "DSP", "QPS", "BAN", time);
    }

    public static KeyGenerator getPackageNameKey() {
        return () -> KeyBuilder.build("ADX", "PACKAGENAME", "VERIFY");
    }

    public static KeyGenerator getClickMacroDsp() {
        return () -> KeyBuilder.build("ADX", "DSP", "MACRO", "CLICK");
    }

    public static KeyGenerator getVideoMacroDsp() {
        return () -> KeyBuilder.build("ADX", "DSP", "MACRO", "VIDEO");
    }

    public static class Dispather {

        public static KeyGenerator getKeyGenerator(String positionId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "PID_AB", positionId);
        }

        public static KeyGenerator getKeyGeneratorByAppPosId(String appPosId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "APPID_AB", appPosId);
        }

        public static KeyGenerator getKeyGeneratorByBucketing(String positionId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "BUCKETING_AB", positionId);
        }

        public static KeyGenerator getKeyGeneratorByAll(String positionId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "ALL_AB", positionId);
        }

        public static KeyGenerator getDispatcherKeyGeneratorByUid(String positionId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "USER_AB", positionId);
        }

        /**
         * 注意：此处因为配置推送是根据广告位推送的，不是根据广告位下具体的配置推送的，
         * 所以configid字段放在hash类型的Key里拼接处理，不直接放在rediskey上
         *
         * @param positionId
         * @return
         */
        public static KeyGenerator getKeyGeneratorByConfig(String positionId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "PID_AB", "CONFIG", positionId);
        }

        public static KeyGenerator getKeyGeneratorByConfigAndAppPosId(String appPosId) {
            return () -> KeyBuilder.build("ADX", "DISPATHER", "APPID_AB", "CONFIG", appPosId);
        }
    }

    public static KeyGenerator getResponseCacheKey(String dspId, String dspTagId, String uid) {
        return () -> KeyBuilder.build("ADX", "CACHE", "RESPONSE", dspId, dspTagId, uid);
    }

    public static KeyGenerator getCrowdPackageNewKey(Device device) {
        if (Objects.nonNull(device)) {
            if (StringUtils.isNotBlank(device.getOaid_md5())) {
                return () -> KeyBuilder.build("oaid", device.getOaid_md5());
            } else if (StringUtils.isNotBlank(device.getImei_md5())) {
                return () -> KeyBuilder.build("imei", device.getImei_md5());
            } else if (StringUtils.isNotBlank(device.getIdfa_md5())) {
                return () -> KeyBuilder.build("idfa", device.getIdfa_md5());
            } else if (StringUtils.isNotBlank(device.getCaid())) {
                return () -> KeyBuilder.build("caid", device.getCaid());
            }
        }
        return null;
    }

    public static List<KeyGenerator> getCrowdPackageNewKeys(Device device) {
        List<KeyGenerator> keyGenerators = new ArrayList<>();
        if (Objects.nonNull(device)) {
            if (StringUtils.isNotBlank(device.getOaid_md5())) {
                keyGenerators.add(() -> KeyBuilder.build("oaid", device.getOaid_md5()));
            }
            if (StringUtils.isNotBlank(device.getImei_md5())) {
                keyGenerators.add(() -> KeyBuilder.build("imei", device.getImei_md5()));
            }
            if (StringUtils.isNotBlank(device.getIdfa_md5())) {
                keyGenerators.add(() -> KeyBuilder.build("idfa", device.getIdfa_md5()));
            }
            if (CollectionUtils.isNotEmpty(device.getCaid_info())) {
                device.getCaid_info().forEach(caid -> {
                    if (StringUtils.isNotBlank(caid.getCaid())) {
                        keyGenerators.add(() -> KeyBuilder.build("caid", caid.getCaid()));
                    }
                });
            }
        }
        return keyGenerators;
    }

    public static class ServerReport {
        public static KeyGenerator getServerReportTempKey(String type, String bidid) {
            return () -> KeyBuilder.build("SERVER", "REPORT", type, bidid);
        }

        public static KeyGenerator getServerReportTempKey(String type, String bidid, String adId) {
            return () -> KeyBuilder.build("SERVER", "REPORT", type, bidid, adId);
        }
    }

    /**
     * 用于存放曝光302中bxm-adx的曝光链接
     *
     * @param bidId
     * @param mediaId
     * @param tagId
     * @param dspId
     * @param dspTagId
     * @return
     */
    public static KeyGenerator getImpUrl302(String bidId, String mediaId, String tagId, String dspId, String dspTagId) {
        return () -> KeyBuilder.build("ADX", "IMP", bidId, mediaId, tagId, dspId, dspTagId);
    }

    public static class DispatcherFlow {
        public static String baseFlow(String param) {
            return KeyBuilder.build("ADX", "FLOW", param);
        }

        public static String basePercent(String param) {
            return KeyBuilder.build("ADX", "CUT", param);
        }

        /**
         * 流量砍量开, 由数据写入
         *
         * @param dspId
         * @param dspTagId
         * @param dspAppId
         * @param tagId
         * @param appId
         * @return
         */
        public static KeyGenerator getDispatcherFlow(String date, String dspId, String dspTagId, String dspAppId, String tagId, String appId) {
            return () -> KeyBuilder.build("ADX", "FLOW", date, dspId, dspTagId, dspAppId, tagId, appId);
        }

        /**
         * 流量砍量百分比
         *
         * @param dspId
         * @param dspTagId
         * @param dspAppId
         * @param tagId
         * @param appPkg
         * @return
         */
        public static KeyGenerator getDispatcherFlowPercent(String date, String dspId, String dspAppId, String dspTagId, String tagId, String appPkg) {
            return () -> KeyBuilder.build("ADX", "CUT", date, dspId, dspAppId, dspTagId, tagId, appPkg);
        }
    }
}
