package com.bxm.adx.common;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author fgf
 * @date 2023-04-03
 * @since 1.0
 */
@Data
@Validated
@ConfigurationProperties(prefix = "device.jedis")
public class DeviceCrowdPackageJedisProperties extends JedisPoolConfig {

    private String host = Protocol.DEFAULT_HOST;
    private String password;
    private int port = Protocol.DEFAULT_PORT;
    private int timeout = Protocol.DEFAULT_TIMEOUT;
    private int database = Protocol.DEFAULT_DATABASE;

    /**
     * 新的人群包数据在db-10中
     */
    private int newDatabase = 11;

    /**
     * 人群包屏蔽规则配置
     * key: dspCode val: crowdPackId
     */
    private Map<String, String> blockCrowdPackConfigs = new HashMap<>();
}
