package com.bxm.adx.common;

import lombok.Getter;

/**
 * @author zhangdong
 * @date 2022/8/22
 */
@Getter
public enum GenderEnum {


    /**
     * 不限/未知
     */
    UNLIMITED(0, "不限"),
    /**
     * 男
     */
    MAN(1, "男"),
    /**
     * 女
     */
    WOMAN(2, "女");

    /**
     * 类型
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    GenderEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        GenderEnum enumByCode = getEnumByCode(code);
        if (enumByCode == null) {
            return null;
        }
        return enumByCode.desc;
    }

    public static GenderEnum getEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (GenderEnum genderEnum : GenderEnum.values()) {
            if (genderEnum.code.equals(code)) {
                return genderEnum;
            }
        }
        return null;
    }
}
